import re
from pypinyin import lazy_pinyin

input_file = "kw3.2_ini.js"
output_file = "kw3.2.js"

# 读取文件
with open(input_file, "r", encoding="utf-8") as f:
    js_code = f.read()

# 匹配 kw:`内容`
pattern = r"kw:`([^`]*)`"

def add_pinyin(match):
    content = match.group(1)
    # 提取中文
    chinese_words = re.findall(r"[\u4e00-\u9fa5]+", content)
    if chinese_words:
        # 生成拼音
        py = ["".join(lazy_pinyin(word)) for word in chinese_words]
        pinyin = "".join(py)
        # 末尾加拼音
        if not content.endswith(',') and not content.endswith(' '):
            content += ','
        content += pinyin
    return f"kw:`{content}`"

# 替换内容
result = re.sub(pattern, add_pinyin, js_code)

# 写入新文件
with open(output_file, "w", encoding="utf-8") as f:
    f.write(result)

print(f"✅ 已生成带拼音的文件：{output_file}")
